$(document).ready(function () {
    // Fonction pour ajouter les images dans le conteneur
    function addImagesToContainer(data) {
        // Vider le conteneur avant d'ajouter de nouvelles images
        $('#image-container').empty();

        // Créer et ajouter les images
        data.forEach(function (item) {
        var cadreDiv = $('<div>').addClass('cadre');
        var newImg = $('<img>')
            .attr('src', item.image)  
            .attr('alt', item.titre) 
            .addClass('dynamic-image');
        var titre = $('<h2>').addClass('titre').text(item.titre); 
        
        var texte = $('<p>').addClass('texte').text(item.texte);

        cadreDiv.append(newImg).append(titre).append(texte);

        // Ajouter la div au conteneur principal
        $('#image-container').append(cadreDiv);
    });
}
    // Gérer le changement pour le pays

    $('select , .exclusive').on('change', function () {
        // Récupérer les valeurs des trois sélecteurs
        var pays = $('#pays').val();
        var matiere = $('#matiere').val();
        var temps = $('#temps').val();
        
        var danger = $('.exclusive:checked').val(); // Seulement la valeur de la case sélectionnée
        
        // Si aucune case n'est cochée, la valeur de danger sera undefined
        if (typeof danger === "undefined") {
            danger = ''; // Si aucune case n'est cochée, mettre danger à vide
        }

        // Envoyer une requête AJAX avec les trois critères
        $.ajax({
            url: 'arme.php', 
            type: 'POST',
            data: {
                pays: pays,
                matiere: matiere,
                temps: temps,
                danger : danger
            },
            success: function (response) {
                var data = JSON.parse(response);// Parser la réponse JSON
                addImagesToContainer(data);  // Ajouter les images au conteneur
            },

            error: function () {
                console.error("Erreur lors de la requête AJAX.");
            }
        });
    });

    
});




    
 